"""
There are 3 main files, SConstruct, config.py, run.py.
	SConstruct: 
		Builds the .java file, in the buildresource parameter, OR, the src directory. If you don't specify 
		buildresource parameter src directory is assumed.
	config.py:
		Has main functions, and the directory structure of the app. 
		The directory structure is as follows.
		src: This dir. has all the src files, to build.
		lib: contains all the lib files, which are included in the classpath at the time of compilation and running.
		bin: contains, the compiled class files.
		tools: contains the files for scons-local, and other tools like junit, or testng, etc. which you wish to 
		       include in your app.
	run.py:
		Calls SConstruct for building the .java file passed as parameter, on successfull build, runs the java class.
"""




"""
    This module provides, directory structure of application, and, reusable main functions.
"""

import os

sourceDir = "src"
outputDir = "bin"
libDir = "lib"
toolsDir = "tools"
toolsJunitDir = os.path.join(toolsDir, "junit")

sconsLocalDir = os.path.join(os.path.join(toolsDir,"scons"),"scons-local-0.98.4")


def walkDirs(path):
    #helper function to get a list of all subdirectories"""
    def addDirs(pathList, dirName, names):
        #internal function to pass to os.path.walk"""        
        for n in names:
            f = os.path.join(dirName, n)
            if os.path.isfile(f):
                pathList.append(f)                
                
    pathList = [path]
    os.path.walk(path, addDirs, pathList)        
    return pathList
