"""
There are 3 main files, SConstruct, config.py, run.py.
	SConstruct: 
		Builds the .java file, in the buildresource parameter, OR, the src directory. If you don't specify 
		buildresource parameter src directory is assumed.
	config.py:
		Has main functions, and the directory structure of the app. 
		The directory structure is as follows.
		src: This dir. has all the src files, to build.
		lib: contains all the lib files, which are included in the classpath at the time of compilation and running.
		bin: contains, the compiled class files.
		tools: contains the files for scons-local, and other tools like junit, or testng, etc. which you wish to 
		       include in your app.
	run.py:
		Calls SConstruct for building the .java file passed as parameter, on successfull build, runs the java class.
"""




"""
This module, upon successfull compilation of input .java file, runs the java class. Accepts input Java Arguments, if 
--javaargs option is provided.
"""

import os
import sys
import config
import getopt

opts, filePath = getopt.getopt( sys.argv[1:], None, ("javaargs") )

if (filePath == [ ]):
    print "Usage: python run.py [--javaargs] filepath"
    sys.exit(3)


#Convert filePath in Proper Class Name, with leading packages.
leadingDirRemoved = filePath[0].partition("/") 
javaClassName = leadingDirRemoved[2].replace("/",".")
if ( javaClassName.endswith(".java") ):    
    javaClassName = javaClassName[0:-5]
else:
    print "The Active File should be a .java file"
    sys.exit(2)


#if we can use subprocess.call, it would be better.
buildReturnCode = os.system("python" + " " + os.path.join(config.sconsLocalDir,"scons.py") + " " + "buildresource=" + filePath[0])


#if successfull build, then, Run the Class.
if buildReturnCode == 0:
    javaArguments = None
    for opt,value in opts:
        if (opt=="--javaargs"):
            javaArguments = raw_input("Input your Java Arguments, space b/w them, press Enter to finish\n") 
    
    #Get the files and directories in lib
    libFiles = config.walkDirs(config.libDir)
    
    #Get the file names, in lib 
    libFileNames = ""
    for libFileName in libFiles:
        libFileNames = libFileNames + libFileName + os.pathsep
    libFileNames = libFileNames[0:-1]
    libFileNames = config.outputDir + os.pathsep + libFileNames
    
    if javaArguments == None:
        javaRunCommand = "java -classpath" + " "  + libFileNames + " " + javaClassName
    else: 
        javaRunCommand = "java -classpath" + " "  + libFileNames + " " + javaClassName + " " + javaArguments
    
    os.system(javaRunCommand)
